﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="TableSettings.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Settings.TableSettings" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="pageheader">
        <h2>
            <i class="fa fa-users"></i>POS Settings
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li class="active">Settings</li>
            </ol>
        </div>
    </div>
    <ul class="nav nav-tabs" data-tabs="tabs" id="SettingsTab">
        <li><a href="Settings.aspx">General Settings</a></li>
        <li><a href="HappyHourSettings.aspx">Happy Hours</a></li>
        <li class="active"><a data-toggle="tab" href="#Tables">Tables</a></li>
    </ul>

    <div class="tab-content responsive contentField">
        <div id="Tables" class="tab-pane active cwhite" style="padding-top: 20px;">
            <br />
            <div class="row">
                <div class="col-xs-12 col-md-2 col-sm-2">
                    Table Name
                </div>
                <div class="col-xs-12 col-md-4 col-sm-4">
                    <asp:TextBox runat="server" ID="txtTableName" MaxLength="50" />
                </div>
            </div>
            <br />
            <div class="row">
                <div class="col-xs-12 col-md-2 col-sm-2">
                    Table Capacity
                </div>
                <div class="col-xs-12 col-md-4 col-sm-4">
                    <asp:TextBox runat="server" ID="txtTableCapacity" />
                </div>
            </div>
            <br />
           <div class="row">
                <div class="col-xs-12 col-md-6 text-center">
                    <asp:Button runat="server" ID="btnSaveTableSetting" OnClick="btnSaveTableSetting_Click" Text="Save" CssClass="btn btn-lg btn-danger" />
                </div>
            </div>
            <br />
            <div class="row">
                <div class="col-md-12 col-xs-12 table-responsive">
                    <asp:GridView runat="server" ID="gvTables" AutoGenerateColumns="false" CssClass="table" DataKeyNames="TableID" OnRowCancelingEdit="gvTables_RowCancelingEdit" OnRowEditing="gvTables_RowEditing"
                        OnRowDeleting="gvTables_RowDeleting" OnRowUpdating="gvTables_RowUpdating">
                        <Columns>
                            <asp:TemplateField>
                                <ItemTemplate>
                                    <%# Container.DataItemIndex+1 %>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="Name">
                                <ItemTemplate>
                                    <%# Eval("TableName") %>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <asp:TextBox runat="server" ID="txtNameEdit" Text='<%# Eval("TableName") %>' />
                                </EditItemTemplate>
                                </asp:TemplateField>
                             <asp:TemplateField HeaderText="Capacity">
                                <ItemTemplate>
                                    <%# Eval("TableCapacity") %>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <asp:TextBox runat="server" ID="txtTableCapacityEdit" Text='<%# Eval("TableCapacity") %>' />
                                </EditItemTemplate>
                                </asp:TemplateField>
                            <asp:CommandField ControlStyle-CssClass="btn btn-primary" ShowEditButton="true" />
                            <asp:CommandField ControlStyle-CssClass="btn btn-primary" ShowDeleteButton="true" />
                        </Columns>
                        <HeaderStyle CssClass="tbl-header" />
                        <RowStyle CssClass="tbl-row" />
                        <AlternatingRowStyle CssClass="tbl-row" />
                        <EmptyDataRowStyle />
                        <EmptyDataTemplate>
                            No Record found
                        </EmptyDataTemplate>
                        <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                    </asp:GridView>
                </div>
            </div>
        </div>
    </div>
    <asp:Button runat="server" ID="btnDeleteTable" style="display:none;" OnClick="btnDeleteTable_Click" />
    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script>
        function ConfirmDelete() {
            if (confirm("Are you sure want to delete?")) {
                $('#<%= btnDeleteTable.ClientID %>').click();
            }
        }
    </script>
</asp:Content>
